<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        Invoice of <?= get_brand_data($items['brand_id'], $items['uid'])->brand_name; ?>
        to <?= @$items['customer_name'] ?>
    </title>

    <link rel="shortcut icon" type="image/x-icon"
          href="<?= base_url(get_brand_data($items['brand_id'], $items['uid'])->brand_logo); ?>">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css"
          rel="stylesheet">

    <style>
        /* ================= Base styles ================= */
        body {
            margin: 0;
            padding: 0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: #e5edf8;
        }

        /* Print mode */
        @media print {
            .action-btn {
                display: none !important;
            }

            body {
                background: #ffffff !important;
            }

            .container {
                max-width: 100% !important;
                width: 100% !important;
                margin: 0 !important;
                padding: 0 !important;
            }

            .invoice-wrapper {
                box-shadow: none !important;
                border-radius: 0 !important;
            }
        }

        /* ================= Invoice wrapper ================= */
        .invoice-wrapper {
            max-width: 900px;
            margin: 30px auto;
            padding: 28px 26px 32px;
            background: #ffffff;
            border-radius: 20px;
            box-shadow: 0 25px 60px rgba(15, 23, 42, 0.25);
            border: 1px solid rgba(203, 213, 225, 0.7);
        }

        /* ================= Header ================= */
        .invoice-title {
            text-align: center;
            margin-bottom: 24px;
        }

        .invoice-title span {
            display: inline-block;
            font-size: 12px;
            letter-spacing: 0.22em;
            text-transform: uppercase;
            color: #64748b;
        }

        .invoice-title h1 {
            font-size: 32px;
            font-weight: 900;
            margin: 6px 0 0;
            color: #0f172a;
        }

        .top-section {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 16px;
            margin-bottom: 24px;
            border-radius: 16px;
            padding: 16px 18px;
            background: linear-gradient(135deg, #eef2ff, #f9fafb);
            border: 1px solid #e2e8f0;
        }

        .brand-info h4 {
            margin: 4px 0 0;
            font-size: 16px;
            font-weight: 700;
            color: #1f2937;
        }

        .brand-info img {
            border-radius: 12px;
            border: 1px solid #e5e7eb;
            background: #ffffff;
        }

        /* ================= Status ================= */
        .invoice-status {
            text-align: right;
        }

        .invoice-status h3 {
            font-size: 15px;
            margin: 0 0 4px;
            font-weight: 600;
            color: #111827;
        }

        .status-badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 12px;
            font-weight: 700;
        }

        .status-pending {
            background: rgba(59, 130, 246, 0.12);
            color: #1d4ed8;
        }

        .status-paid {
            background: rgba(34, 197, 94, 0.14);
            color: #15803d;
        }

        .status-unpaid {
            background: rgba(239, 68, 68, 0.14);
            color: #b91c1c;
        }

        .invoice-status p {
            margin: 0;
            font-size: 13px;
            color: #6b7280;
        }

        /* ================= Content cards ================= */
        .invoice-box {
            padding: 18px 16px 20px;
            border-radius: 16px;
            border: 1px solid #e5e7eb;
            background: #f9fafb;
            margin-bottom: 18px;
        }

        .invoice-box h2 {
            font-size: 18px;
            font-weight: 700;
            margin: 0 0 12px;
            color: #1f2937;
        }

        .invoice-box p {
            margin: 3px 0;
            font-size: 14px;
            color: #4b5563;
        }

        /* ================= Table ================= */
        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }

        .invoice-table th,
        .invoice-table td {
            border: 1px solid #e5e7eb;
            padding: 10px 12px;
        }

        .invoice-table th {
            background: #111827;
            color: #f9fafb;
            font-weight: 600;
        }

        .invoice-table tr:nth-child(even) td {
            background: #f3f4f6;
        }

        .total-row td {
            background: #111827 !important;
            color: #f9fafb;
            font-weight: 700;
        }

        /* ================= Buttons ================= */
        .action-btn {
            background: linear-gradient(120deg, #2563eb, #0ea5e9);
            border: none;
            color: #ffffff;
            padding: 10px 22px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
            font-weight: 600;
            border-radius: 999px;
            margin-top: 10px;
            cursor: pointer;
            box-shadow: 0 16px 35px rgba(37, 99, 235, 0.45);
            transition: 0.25s;
        }

        .action-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 22px 48px rgba(37, 99, 235, 0.65);
        }

        /* ================= Responsive ================= */
        @media (max-width: 768px) {
            .invoice-wrapper {
                margin: 12px auto;
                padding: 20px 16px 24px;
            }

            .top-section {
                flex-direction: column;
                align-items: flex-start;
            }

            .invoice-status {
                text-align: left;
                width: 100%;
            }
        }
    </style>
</head>

<body>

<div class="container">
    <div class="invoice-wrapper">

        <!-- ===== TITLE ===== -->
        <div class="invoice-title">
            <span>Payment Invoice</span>
            <h1>INVOICE</h1>
        </div>

        <!-- ===== BRAND & STATUS ===== -->
        <div class="top-section">
            <!-- Brand / business info -->
            <div class="brand-info d-flex align-items-center gap-3">
                <img src="<?= base_url(get_brand_data($items['brand_id'], $items['uid'])->brand_logo) ?>"
                     width="60" alt="Brand Logo">
                <div>
                    <h4 class="mb-0"><?= get_option('business_name') ?></h4>
                    <small class="text-muted">
                        <?= get_brand_data($items['brand_id'], $items['uid'])->brand_name; ?>
                    </small>
                </div>
            </div>

            <!-- Payment status -->
            <div class="invoice-status">
                <?php if (@$items['pay_status'] == 1) : ?>
                    <h3>
                        Payment Status:
                        <span class="status-badge status-pending">Pending</span>
                    </h3>
                    <p>TrxId: <?= @$items['transaction_id'] ?></p>

                <?php elseif (@$items['pay_status'] == 2) : ?>
                    <h3>
                        Payment Status:
                        <span class="status-badge status-paid">Paid</span>
                    </h3>
                    <p>TrxId: <?= @$items['transaction_id'] ?></p>

                <?php else : ?>
                    <h3>
                        Payment Status:
                        <span class="status-badge status-unpaid">Unpaid</span>
                    </h3>
                    <button class="action-btn rounded"
                            onclick="location.href='?start_payment=<?= @$items['ids'] ?>'">
                        Pay Now
                    </button>
                <?php endif; ?>
            </div>
        </div>

        <!-- ===== INVOICE META ===== -->
        <div class="invoice-box">
            <h2>Invoice Details</h2>

            <div class="table-responsive">
                <table class="invoice-table">
                    <tr>
                        <th>Invoice No.</th>
                        <td>#<?= @$items['invoice_ids'] ?></td>
                    </tr>
                    <tr>
                        <th>Creation Date</th>
                        <td><?= @time_format($items['created_at']) ?></td>
                    </tr>
                    <tr>
                        <th>Pay To</th>
                        <td><?= get_brand_data($items['brand_id'], $items['uid'])->brand_name; ?></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- ===== CUSTOMER INFO ===== -->
        <div class="invoice-box">
            <h2>Customer Information</h2>

            <p><strong>Name:</strong> <?= @$items['customer_name'] ?></p>
            <p><strong>Number:</strong> <?= @$items['customer_number'] ?></p>
            <p><strong>Email:</strong> <?= @$items['customer_email'] ?></p>

            <?php if (!empty(get_value(@$items['extras'], 'reference'))) : ?>
                <p><strong>Reference:</strong> <?= get_value(@$items['extras'], 'reference') ?></p>
            <?php endif; ?>
        </div>

        <!-- ===== ITEMS TABLE ===== -->
        <div class="invoice-box">
            <h2>Invoice Items</h2>

            <div class="table-responsive">
                <table class="invoice-table">
                    <tr>
                        <th>Description</th>
                        <th>Qty</th>
                        <th>Price</th>
                        <th>Amount</th>
                    </tr>

                    <tr>
                        <td><?= @$items['customer_description'] ?></td>
                        <td>1</td>
                        <td><?= @$items['customer_amount'] . get_option('currency_symbol') ?></td>
                        <td><?= @$items['customer_amount'] . get_option('currency_symbol') ?></td>
                    </tr>

                    <tr class="total-row">
                        <td colspan="3">Total Price</td>
                        <td><?= @$items['customer_amount'] . get_option('currency_symbol') ?></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- ===== PRINT BUTTON ===== -->
        <button class="action-btn rounded mx-auto d-block" onclick="printWithoutHeaders()">
            Print
        </button>

    </div>
</div>

<script>
    function printWithoutHeaders() {
        window.print();
    }
</script>

</body>
</html>
